/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assert;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.AugAssign;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Break;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.Compare;
import org.python.antlr.ast.Continue;
import org.python.antlr.ast.Delete;
import org.python.antlr.ast.Dict;
import org.python.antlr.ast.Ellipsis;
import org.python.antlr.ast.ExceptHandler;
import org.python.antlr.ast.Exec;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.Global;
import org.python.antlr.ast.If;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Pass;
import org.python.antlr.ast.Print;
import org.python.antlr.ast.Raise;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.Subscript;
import org.python.antlr.ast.Suite;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.comprehension;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.operatorType;
import org.python.antlr.base.expr;
import org.python.antlr.base.mod;
import org.python.antlr.base.stmt;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Future;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.ContextGuard;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.core.imp;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;
import org.python.objectweb.asm.commons.Method;
import org.python.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCompiler
extends Visitor
implements Opcodes,
ClassConstants {
    private static final Object Exit = new Integer(1);
    private static final Object NoExit = null;
    private Module module;
    private Code code;
    private CompilerFlags cflags;
    private int temporary;
    private expr_contextType augmode;
    private int augtmp1;
    private int augtmp2;
    private int augtmp3;
    private int augtmp4;
    private boolean fast_locals;
    private boolean print_results;
    private Map<String, SymInfo> tbl;
    private ScopeInfo my_scope;
    private boolean optimizeGlobals = true;
    private String className;
    private Stack<Label> continueLabels;
    private Stack<Label> breakLabels;
    private Stack<ExceptionHandler> exceptionHandlers;
    private Vector<Label> yields = new Vector();
    private int bcfLevel = 0;
    private int yield_count = 0;
    private Stack<String> stack = new Stack();

    public CodeCompiler(Module module, boolean bl) {
        this.module = module;
        this.print_results = bl;
        this.continueLabels = new Stack();
        this.breakLabels = new Stack();
        this.exceptionHandlers = new Stack();
    }

    public void getNone() throws IOException {
        this.code.getstatic(CodegenUtils.p(Py.class), "None", CodegenUtils.ci(PyObject.class));
    }

    public void loadFrame() throws Exception {
        this.code.aload(1);
    }

    public void loadThreadState() throws Exception {
        this.code.aload(2);
    }

    public void setLastI(int n) throws Exception {
        this.loadFrame();
        this.code.iconst(n);
        this.code.putfield(CodegenUtils.p(PyFrame.class), "f_lasti", "I");
    }

    private void loadf_back() throws Exception {
        this.code.getfield(CodegenUtils.p(PyFrame.class), "f_back", CodegenUtils.ci(PyFrame.class));
    }

    public int storeTop() throws Exception {
        int n = this.code.getLocal(CodegenUtils.p(PyObject.class));
        this.code.astore(n);
        return n;
    }

    public void setline(int n) throws Exception {
        if (this.module.linenumbers) {
            this.code.setline(n);
            this.loadFrame();
            this.code.iconst(n);
            this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "setline", CodegenUtils.sig(Void.TYPE, Integer.TYPE));
        }
    }

    public void setline(PythonTree pythonTree) throws Exception {
        this.setline(pythonTree.getLine());
    }

    public void set(PythonTree pythonTree) throws Exception {
        int n = this.storeTop();
        this.set(pythonTree, n);
        this.code.aconst_null();
        this.code.astore(n);
        this.code.freeLocal(n);
    }

    public void set(PythonTree pythonTree, int n) throws Exception {
        this.temporary = n;
        this.visit(pythonTree);
    }

    private void saveAugTmps(PythonTree pythonTree, int n) throws Exception {
        if (n >= 4) {
            this.augtmp4 = this.code.getLocal(CodegenUtils.ci(PyObject.class));
            this.code.astore(this.augtmp4);
        }
        if (n >= 3) {
            this.augtmp3 = this.code.getLocal(CodegenUtils.ci(PyObject.class));
            this.code.astore(this.augtmp3);
        }
        if (n >= 2) {
            this.augtmp2 = this.code.getLocal(CodegenUtils.ci(PyObject.class));
            this.code.astore(this.augtmp2);
        }
        this.augtmp1 = this.code.getLocal(CodegenUtils.ci(PyObject.class));
        this.code.astore(this.augtmp1);
        this.code.aload(this.augtmp1);
        if (n >= 2) {
            this.code.aload(this.augtmp2);
        }
        if (n >= 3) {
            this.code.aload(this.augtmp3);
        }
        if (n >= 4) {
            this.code.aload(this.augtmp4);
        }
    }

    private void restoreAugTmps(PythonTree pythonTree, int n) throws Exception {
        this.code.aload(this.augtmp1);
        this.code.freeLocal(this.augtmp1);
        if (n == 1) {
            return;
        }
        this.code.aload(this.augtmp2);
        this.code.freeLocal(this.augtmp2);
        if (n == 2) {
            return;
        }
        this.code.aload(this.augtmp3);
        this.code.freeLocal(this.augtmp3);
        if (n == 3) {
            return;
        }
        this.code.aload(this.augtmp4);
        this.code.freeLocal(this.augtmp4);
    }

    static boolean checkOptimizeGlobals(boolean bl, ScopeInfo scopeInfo) {
        return bl && !scopeInfo.exec && !scopeInfo.from_import_star;
    }

    void parse(mod mod2, Code code, boolean bl, String string, Str str, boolean bl2, ScopeInfo scopeInfo, CompilerFlags compilerFlags) throws Exception {
        Object object;
        this.fast_locals = bl;
        this.className = string;
        this.code = code;
        this.cflags = compilerFlags;
        this.my_scope = scopeInfo;
        this.tbl = scopeInfo.tbl;
        if (bl2) {
            this.loadFrame();
            code.ldc("__module__");
            this.loadFrame();
            code.ldc("__name__");
            code.invokevirtual(CodegenUtils.p(PyFrame.class), "getname", CodegenUtils.sig(PyObject.class, String.class));
            code.invokevirtual(CodegenUtils.p(PyFrame.class), "setlocal", CodegenUtils.sig(Void.TYPE, String.class, PyObject.class));
            if (str != null) {
                this.loadFrame();
                code.ldc("__doc__");
                this.visit(str);
                code.invokevirtual(CodegenUtils.p(PyFrame.class), "setlocal", CodegenUtils.sig(Void.TYPE, String.class, PyObject.class));
            }
        }
        Label label = new Label();
        if (this.my_scope.generator) {
            code.goto_(label);
        }
        Label label2 = new Label();
        code.label(label2);
        int n = this.my_scope.jy_paramcells.size();
        if (n > 0) {
            object = this.my_scope.jy_paramcells;
            for (int i = 0; i < n; ++i) {
                code.aload(1);
                SymInfo symInfo = this.tbl.get(object.get(i));
                code.iconst(symInfo.locals_index);
                code.iconst(symInfo.env_index);
                code.invokevirtual(CodegenUtils.p(PyFrame.class), "to_cell", CodegenUtils.sig(Void.TYPE, Integer.TYPE, Integer.TYPE));
            }
        }
        this.optimizeGlobals = CodeCompiler.checkOptimizeGlobals(bl, this.my_scope);
        if (this.my_scope.max_with_count > 0) {
            this.loadFrame();
            code.iconst(this.my_scope.max_with_count);
            code.anewarray(CodegenUtils.p(PyObject.class));
            code.putfield(CodegenUtils.p(PyFrame.class), "f_exits", CodegenUtils.ci(PyObject[].class));
        }
        object = this.visit(mod2);
        if (bl2) {
            this.loadFrame();
            code.invokevirtual(CodegenUtils.p(PyFrame.class), "getf_locals", CodegenUtils.sig(PyObject.class, new Class[0]));
            code.areturn();
        } else if (object == null) {
            this.setLastI(-1);
            this.getNone();
            code.areturn();
        }
        if (this.my_scope.generator) {
            code.label(label);
            code.aload(1);
            code.getfield(CodegenUtils.p(PyFrame.class), "f_lasti", "I");
            Label[] labelArray = new Label[this.yields.size() + 1];
            labelArray[0] = label2;
            for (int i = 1; i < labelArray.length; ++i) {
                labelArray[i] = this.yields.get(i - 1);
            }
            code.tableswitch(0, labelArray.length - 1, label2, labelArray);
        }
    }

    @Override
    public Object visitInteractive(Interactive interactive) throws Exception {
        this.traverse(interactive);
        return null;
    }

    @Override
    public Object visitModule(org.python.antlr.ast.Module module) throws Exception {
        Str str = this.getDocStr(module.getInternalBody());
        if (str != null) {
            this.loadFrame();
            this.code.ldc("__doc__");
            this.visit(str);
            this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "setglobal", CodegenUtils.sig(Void.TYPE, String.class, PyObject.class));
        }
        this.traverse(module);
        return null;
    }

    @Override
    public Object visitExpression(Expression expression) throws Exception {
        if (this.my_scope.generator && expression.getInternalBody() != null) {
            this.module.error("'return' with argument inside generator", true, expression);
        }
        return this.visitReturn(new Return(expression, expression.getInternalBody()), true);
    }

    public int makeArray(java.util.List<? extends PythonTree> list) throws Exception {
        int n = list == null ? 0 : list.size();
        int n2 = this.code.getLocal(CodegenUtils.ci(PyObject[].class));
        if (n == 0) {
            this.code.getstatic(CodegenUtils.p(Py.class), "EmptyObjects", CodegenUtils.ci(PyObject[].class));
            this.code.astore(n2);
        } else {
            this.code.iconst(n);
            this.code.anewarray(CodegenUtils.p(PyObject.class));
            this.code.astore(n2);
            for (int i = 0; i < n; ++i) {
                this.visit(list.get(i));
                this.code.aload(n2);
                this.code.swap();
                this.code.iconst(i);
                this.code.swap();
                this.code.aastore();
            }
        }
        return n2;
    }

    public void freeArray(int n) {
        this.code.aload(n);
        this.code.aconst_null();
        this.code.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, Object[].class, Object.class));
        this.code.freeLocal(n);
    }

    public void freeArrayRef(int n) {
        this.code.aconst_null();
        this.code.astore(n);
        this.code.freeLocal(n);
    }

    public Str getDocStr(java.util.List<stmt> list) {
        stmt stmt2;
        if (list.size() > 0 && (stmt2 = list.get(0)) instanceof Expr && ((Expr)stmt2).getInternalValue() instanceof Str) {
            return (Str)((Expr)stmt2).getInternalValue();
        }
        return null;
    }

    public boolean makeClosure(ScopeInfo scopeInfo) throws Exception {
        if (scopeInfo == null || scopeInfo.freevars == null) {
            return false;
        }
        int n = scopeInfo.freevars.size();
        if (n == 0) {
            return false;
        }
        int n2 = this.code.getLocal(CodegenUtils.ci(PyObject[].class));
        this.code.iconst(n);
        this.code.anewarray(CodegenUtils.p(PyObject.class));
        this.code.astore(n2);
        Map<String, SymInfo> map = scopeInfo.up.tbl;
        for (int i = 0; i < n; ++i) {
            this.code.aload(n2);
            this.code.iconst(i);
            this.loadFrame();
            for (int j = 1; j < scopeInfo.distance; ++j) {
                this.loadf_back();
            }
            SymInfo symInfo = map.get(scopeInfo.freevars.elementAt(i));
            this.code.iconst(symInfo.env_index);
            this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getclosure", CodegenUtils.sig(PyObject.class, Integer.TYPE));
            this.code.aastore();
        }
        this.code.aload(n2);
        this.code.freeLocal(n2);
        return true;
    }

    @Override
    public Object visitFunctionDef(FunctionDef functionDef) throws Exception {
        String string = this.getName(functionDef.getInternalName());
        this.setline(functionDef);
        ScopeInfo scopeInfo = this.module.getScopeInfo(functionDef);
        int n = this.makeArray(scopeInfo.ac.getDefaults());
        this.code.new_(CodegenUtils.p(PyFunction.class));
        this.code.dup();
        this.loadFrame();
        this.code.getfield(CodegenUtils.p(PyFrame.class), "f_globals", CodegenUtils.ci(PyObject.class));
        this.code.aload(n);
        this.code.freeLocal(n);
        scopeInfo.setup_closure();
        scopeInfo.dump();
        this.module.codeConstant(new Suite(functionDef, functionDef.getInternalBody()), string, true, this.className, false, false, functionDef.getLine(), scopeInfo, this.cflags).get(this.code);
        Str str = this.getDocStr(functionDef.getInternalBody());
        if (str != null) {
            this.visit(str);
        } else {
            this.code.aconst_null();
        }
        if (!this.makeClosure(scopeInfo)) {
            this.code.invokespecial(CodegenUtils.p(PyFunction.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject[].class, PyCode.class, PyObject.class));
        } else {
            this.code.invokespecial(CodegenUtils.p(PyFunction.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject[].class, PyCode.class, PyObject.class, PyObject[].class));
        }
        this.applyDecorators(functionDef.getInternalDecorator_list());
        this.set(new Name(functionDef, functionDef.getInternalName(), expr_contextType.Store));
        return null;
    }

    private void applyDecorators(java.util.List<expr> list) throws Exception {
        if (list != null && !list.isEmpty()) {
            int n = this.storeTop();
            for (expr expr2 : list) {
                this.visit(expr2);
                this.stackProduce();
            }
            for (int i = list.size(); i > 0; --i) {
                this.stackConsume();
                this.loadThreadState();
                this.code.aload(n);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class));
                this.code.astore(n);
            }
            this.code.aload(n);
            this.code.freeLocal(n);
        }
    }

    @Override
    public Object visitExpr(Expr expr2) throws Exception {
        this.setline(expr2);
        this.visit(expr2.getInternalValue());
        if (this.print_results) {
            this.code.invokestatic(CodegenUtils.p(Py.class), "printResult", CodegenUtils.sig(Void.TYPE, PyObject.class));
        } else {
            this.code.pop();
        }
        return null;
    }

    @Override
    public Object visitAssign(Assign assign) throws Exception {
        this.setline(assign);
        this.visit(assign.getInternalValue());
        if (assign.getInternalTargets().size() == 1) {
            this.set(assign.getInternalTargets().get(0));
        } else {
            int n = this.storeTop();
            for (expr expr2 : assign.getInternalTargets()) {
                this.set(expr2, n);
            }
            this.code.freeLocal(n);
        }
        return null;
    }

    @Override
    public Object visitPrint(Print print) throws Exception {
        this.setline(print);
        int n = -1;
        if (print.getInternalDest() != null) {
            this.visit(print.getInternalDest());
            n = this.storeTop();
        }
        if (print.getInternalValues() == null || print.getInternalValues().size() == 0) {
            if (print.getInternalDest() != null) {
                this.code.aload(n);
                this.code.invokestatic(CodegenUtils.p(Py.class), "printlnv", CodegenUtils.sig(Void.TYPE, PyObject.class));
            } else {
                this.code.invokestatic(CodegenUtils.p(Py.class), "println", CodegenUtils.sig(Void.TYPE, new Class[0]));
            }
        } else {
            for (int i = 0; i < print.getInternalValues().size(); ++i) {
                if (print.getInternalDest() != null) {
                    this.code.aload(n);
                    this.visit(print.getInternalValues().get(i));
                    if (print.getInternalNl().booleanValue() && i == print.getInternalValues().size() - 1) {
                        this.code.invokestatic(CodegenUtils.p(Py.class), "println", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class));
                        continue;
                    }
                    this.code.invokestatic(CodegenUtils.p(Py.class), "printComma", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class));
                    continue;
                }
                this.visit(print.getInternalValues().get(i));
                if (print.getInternalNl().booleanValue() && i == print.getInternalValues().size() - 1) {
                    this.code.invokestatic(CodegenUtils.p(Py.class), "println", CodegenUtils.sig(Void.TYPE, PyObject.class));
                    continue;
                }
                this.code.invokestatic(CodegenUtils.p(Py.class), "printComma", CodegenUtils.sig(Void.TYPE, PyObject.class));
            }
        }
        if (print.getInternalDest() != null) {
            this.code.freeLocal(n);
        }
        return null;
    }

    @Override
    public Object visitDelete(Delete delete) throws Exception {
        this.setline(delete);
        this.traverse(delete);
        return null;
    }

    @Override
    public Object visitPass(Pass pass) throws Exception {
        this.setline(pass);
        return null;
    }

    @Override
    public Object visitBreak(Break break_) throws Exception {
        if (this.breakLabels.empty()) {
            throw new ParseException("'break' outside loop", break_);
        }
        this.doFinallysDownTo(this.bcfLevel);
        this.code.goto_(this.breakLabels.peek());
        return null;
    }

    @Override
    public Object visitContinue(Continue continue_) throws Exception {
        if (this.continueLabels.empty()) {
            throw new ParseException("'continue' not properly in loop", continue_);
        }
        this.doFinallysDownTo(this.bcfLevel);
        this.code.goto_(this.continueLabels.peek());
        return Exit;
    }

    @Override
    public Object visitYield(Yield yield) throws Exception {
        this.setline(yield);
        if (!this.fast_locals) {
            throw new ParseException("'yield' outside function", yield);
        }
        int n = this.saveStack();
        if (yield.getInternalValue() != null) {
            this.visit(yield.getInternalValue());
        } else {
            this.getNone();
        }
        this.setLastI(++this.yield_count);
        this.saveLocals();
        this.code.areturn();
        Label label = new Label();
        this.yields.addElement(label);
        this.code.label(label);
        this.restoreLocals();
        this.restoreStack(n);
        this.loadFrame();
        this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getGeneratorInput", CodegenUtils.sig(Object.class, new Class[0]));
        this.code.dup();
        this.code.instanceof_(CodegenUtils.p(PyException.class));
        Label label2 = new Label();
        this.code.ifeq(label2);
        this.code.checkcast(CodegenUtils.p(Throwable.class));
        this.code.athrow();
        this.code.label(label2);
        this.code.checkcast(CodegenUtils.p(PyObject.class));
        return null;
    }

    private void stackProduce() {
        this.stackProduce(CodegenUtils.p(PyObject.class));
    }

    private void stackProduce(String string) {
        this.stack.push(string);
    }

    private void stackConsume() {
        this.stackConsume(1);
    }

    private void stackConsume(int n) {
        for (int i = 0; i < n; ++i) {
            this.stack.pop();
        }
    }

    private int saveStack() throws Exception {
        if (this.stack.size() > 0) {
            int n = this.code.getLocal(CodegenUtils.ci(Object[].class));
            this.code.iconst(this.stack.size());
            this.code.anewarray(CodegenUtils.p(Object.class));
            this.code.astore(n);
            ListIterator listIterator = this.stack.listIterator(this.stack.size());
            int n2 = 0;
            while (listIterator.hasPrevious()) {
                String string = (String)listIterator.previous();
                if (CodegenUtils.p(ThreadState.class).equals(string)) {
                    this.code.pop();
                } else {
                    this.code.aload(n);
                    this.code.swap();
                    this.code.iconst(n2++);
                    this.code.swap();
                    this.code.aastore();
                }
                ++n2;
            }
            return n;
        }
        return -1;
    }

    private void restoreStack(int n) throws Exception {
        if (this.stack.size() > 0) {
            int n2 = this.stack.size() - 1;
            for (String string : this.stack) {
                if (CodegenUtils.p(ThreadState.class).equals(string)) {
                    this.loadThreadState();
                    continue;
                }
                this.code.aload(n);
                this.code.iconst(n2--);
                this.code.aaload();
                this.code.checkcast(string);
            }
            this.code.freeLocal(n);
        }
    }

    private void restoreLocals() throws Exception {
        this.endExceptionHandlers();
        Vector<String> vector = this.code.getActiveLocals();
        this.loadFrame();
        this.code.getfield(CodegenUtils.p(PyFrame.class), "f_savedlocals", CodegenUtils.ci(Object[].class));
        int n = this.code.getLocal(CodegenUtils.ci(Object[].class));
        this.code.astore(n);
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i);
            if (string == null) continue;
            this.code.aload(n);
            this.code.iconst(i);
            this.code.aaload();
            this.code.checkcast(string);
            this.code.astore(i);
        }
        this.code.freeLocal(n);
        this.restartExceptionHandlers();
    }

    private void endExceptionHandlers() {
        Label label = new Label();
        this.code.label(label);
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            exceptionHandler.exceptionEnds.addElement(label);
        }
    }

    private void restartExceptionHandlers() {
        Label label = new Label();
        this.code.label(label);
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            exceptionHandler.exceptionStarts.addElement(label);
        }
    }

    private void saveLocals() throws Exception {
        Vector<String> vector = this.code.getActiveLocals();
        this.code.iconst(vector.size());
        this.code.anewarray(CodegenUtils.p(Object.class));
        int n = this.code.getLocal(CodegenUtils.ci(Object[].class));
        this.code.astore(n);
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i);
            if (string == null) continue;
            this.code.aload(n);
            this.code.iconst(i);
            if (i == 2222) {
                this.code.aconst_null();
            } else {
                this.code.aload(i);
            }
            this.code.aastore();
        }
        this.loadFrame();
        this.code.aload(n);
        this.code.putfield(CodegenUtils.p(PyFrame.class), "f_savedlocals", CodegenUtils.ci(Object[].class));
        this.code.freeLocal(n);
    }

    @Override
    public Object visitReturn(Return return_) throws Exception {
        return this.visitReturn(return_, false);
    }

    public Object visitReturn(Return return_, boolean bl) throws Exception {
        this.setline(return_);
        if (!bl && !this.fast_locals) {
            throw new ParseException("'return' outside function", return_);
        }
        int n = 0;
        if (return_.getInternalValue() != null) {
            if (this.my_scope.generator) {
                throw new ParseException("'return' with argument inside generator", return_);
            }
            this.visit(return_.getInternalValue());
            n = this.code.getReturnLocal();
            this.code.astore(n);
        }
        this.doFinallysDownTo(0);
        this.setLastI(-1);
        if (return_.getInternalValue() != null) {
            this.code.aload(n);
        } else {
            this.getNone();
        }
        this.code.areturn();
        return Exit;
    }

    @Override
    public Object visitRaise(Raise raise) throws Exception {
        this.setline(raise);
        if (raise.getInternalType() != null) {
            this.visit(raise.getInternalType());
            this.stackProduce();
        }
        if (raise.getInternalInst() != null) {
            this.visit(raise.getInternalInst());
            this.stackProduce();
        }
        if (raise.getInternalTback() != null) {
            this.visit(raise.getInternalTback());
            this.stackProduce();
        }
        if (raise.getInternalType() == null) {
            this.code.invokestatic(CodegenUtils.p(Py.class), "makeException", CodegenUtils.sig(PyException.class, new Class[0]));
        } else if (raise.getInternalInst() == null) {
            this.stackConsume();
            this.code.invokestatic(CodegenUtils.p(Py.class), "makeException", CodegenUtils.sig(PyException.class, PyObject.class));
        } else if (raise.getInternalTback() == null) {
            this.stackConsume(2);
            this.code.invokestatic(CodegenUtils.p(Py.class), "makeException", CodegenUtils.sig(PyException.class, PyObject.class, PyObject.class));
        } else {
            this.stackConsume(3);
            this.code.invokestatic(CodegenUtils.p(Py.class), "makeException", CodegenUtils.sig(PyException.class, PyObject.class, PyObject.class, PyObject.class));
        }
        this.code.athrow();
        return Exit;
    }

    private void defaultImportLevel() {
        if (this.module.getFutures().isAbsoluteImportOn()) {
            this.code.iconst_0();
        } else {
            this.code.iconst_m1();
        }
    }

    @Override
    public Object visitImport(Import import_) throws Exception {
        this.setline(import_);
        for (alias alias2 : import_.getInternalNames()) {
            String string;
            String string2 = null;
            if (alias2.getInternalAsname() != null) {
                string = alias2.getInternalName();
                string2 = alias2.getInternalAsname();
                this.code.ldc(string);
                this.loadFrame();
                this.defaultImportLevel();
                this.code.invokestatic(CodegenUtils.p(imp.class), "importOneAs", CodegenUtils.sig(PyObject.class, String.class, PyFrame.class, Integer.TYPE));
            } else {
                string = alias2.getInternalName();
                string2 = string;
                if (string2.indexOf(46) > 0) {
                    string2 = string2.substring(0, string2.indexOf(46));
                }
                this.code.ldc(string);
                this.loadFrame();
                this.defaultImportLevel();
                this.code.invokestatic(CodegenUtils.p(imp.class), "importOne", CodegenUtils.sig(PyObject.class, String.class, PyFrame.class, Integer.TYPE));
            }
            this.set(new Name(alias2, string2, expr_contextType.Store));
        }
        return null;
    }

    @Override
    public Object visitImportFrom(ImportFrom importFrom) throws Exception {
        Future.checkFromFuture(importFrom);
        this.setline(importFrom);
        this.code.ldc(importFrom.getInternalModule());
        java.util.List<alias> list = importFrom.getInternalNames();
        if (list == null || list.size() == 0) {
            throw new ParseException("Internel parser error", importFrom);
        }
        if (list.size() == 1 && list.get(0).getInternalName().equals("*")) {
            if (importFrom.getInternalLevel() > 0) {
                throw new ParseException("'import *' not allowed with 'from .'", importFrom);
            }
            if (this.my_scope.func_level > 0) {
                this.module.error("import * only allowed at module level", false, importFrom);
                if (this.my_scope.contains_ns_free_vars) {
                    this.module.error("import * is not allowed in function '" + this.my_scope.scope_name + "' because it contains a nested function with free variables", true, importFrom);
                }
            }
            if (this.my_scope.func_level > 1) {
                this.module.error("import * is not allowed in function '" + this.my_scope.scope_name + "' because it is a nested function", true, importFrom);
            }
            this.loadFrame();
            this.defaultImportLevel();
            this.code.invokestatic(CodegenUtils.p(imp.class), "importAll", CodegenUtils.sig(Void.TYPE, String.class, PyFrame.class, Integer.TYPE));
        } else {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n).getInternalName());
                arrayList2.add(list.get(n).getInternalAsname());
                if (arrayList2.get(n) != null) continue;
                arrayList2.set(n, (String)arrayList.get(n));
            }
            n = CodeCompiler.makeStrings(this.code, arrayList);
            this.code.aload(n);
            this.code.freeLocal(n);
            this.loadFrame();
            if (importFrom.getInternalLevel() == 0) {
                this.defaultImportLevel();
            } else {
                this.code.iconst(importFrom.getInternalLevel());
            }
            this.code.invokestatic(CodegenUtils.p(imp.class), "importFrom", CodegenUtils.sig(PyObject[].class, String.class, String[].class, PyFrame.class, Integer.TYPE));
            int n2 = this.storeTop();
            for (int i = 0; i < list.size(); ++i) {
                this.code.aload(n2);
                this.code.iconst(i);
                this.code.aaload();
                this.set(new Name(list.get(i), (String)arrayList2.get(i), expr_contextType.Store));
            }
            this.code.freeLocal(n2);
        }
        return null;
    }

    @Override
    public Object visitGlobal(Global global) throws Exception {
        return null;
    }

    @Override
    public Object visitExec(Exec exec) throws Exception {
        this.setline(exec);
        this.visit(exec.getInternalBody());
        this.stackProduce();
        if (exec.getInternalGlobals() != null) {
            this.visit(exec.getInternalGlobals());
        } else {
            this.code.aconst_null();
        }
        this.stackProduce();
        if (exec.getInternalLocals() != null) {
            this.visit(exec.getInternalLocals());
        } else {
            this.code.aconst_null();
        }
        this.stackProduce();
        this.stackConsume(3);
        this.code.invokestatic(CodegenUtils.p(Py.class), "exec", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class, PyObject.class));
        return null;
    }

    @Override
    public Object visitAssert(Assert assert_) throws Exception {
        this.setline(assert_);
        Label label = new Label();
        this.loadFrame();
        this.emitGetGlobal("__debug__");
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.code.ifeq(label);
        this.visit(assert_.getInternalTest());
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.code.ifne(label);
        if (assert_.getInternalMsg() != null) {
            this.visit(assert_.getInternalMsg());
        } else {
            this.getNone();
        }
        this.loadFrame();
        this.emitGetGlobal("AssertionError");
        this.code.swap();
        this.code.invokestatic(CodegenUtils.p(Py.class), "makeException", CodegenUtils.sig(PyException.class, PyObject.class, PyObject.class));
        this.code.athrow();
        this.code.label(label);
        return null;
    }

    public Object doTest(Label label, If if_, int n) throws Exception {
        Label label2 = new Label();
        this.setline(if_.getInternalTest());
        this.visit(if_.getInternalTest());
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.code.ifeq(label2);
        Object object = this.suite(if_.getInternalBody());
        if (label != null && object == null) {
            this.code.goto_(label);
        }
        this.code.label(label2);
        if (if_.getInternalOrelse() != null) {
            return this.suite(if_.getInternalOrelse()) != null ? object : null;
        }
        return null;
    }

    @Override
    public Object visitIf(If if_) throws Exception {
        Label label = null;
        if (if_.getInternalOrelse() != null) {
            label = new Label();
        }
        Object object = this.doTest(label, if_, 0);
        if (label != null) {
            this.code.label(label);
        }
        return object;
    }

    @Override
    public Object visitIfExp(IfExp ifExp) throws Exception {
        this.setline(ifExp.getInternalTest());
        Label label = new Label();
        Label label2 = new Label();
        this.visit(ifExp.getInternalTest());
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.code.ifeq(label2);
        this.visit(ifExp.getInternalBody());
        this.code.goto_(label);
        this.code.label(label2);
        this.visit(ifExp.getInternalOrelse());
        this.code.label(label);
        return null;
    }

    public int beginLoop() {
        this.continueLabels.push(new Label());
        this.breakLabels.push(new Label());
        int n = this.bcfLevel;
        this.bcfLevel = this.exceptionHandlers.size();
        return n;
    }

    public void finishLoop(int n) {
        this.continueLabels.pop();
        this.breakLabels.pop();
        this.bcfLevel = n;
    }

    @Override
    public Object visitWhile(While while_) throws Exception {
        int n = this.beginLoop();
        Label label = this.continueLabels.peek();
        Label label2 = this.breakLabels.peek();
        Label label3 = new Label();
        this.code.goto_(label);
        this.code.label(label3);
        this.suite(while_.getInternalBody());
        this.code.label(label);
        this.setline(while_);
        this.visit(while_.getInternalTest());
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.code.ifne(label3);
        this.finishLoop(n);
        if (while_.getInternalOrelse() != null) {
            this.suite(while_.getInternalOrelse());
        }
        this.code.label(label2);
        return null;
    }

    @Override
    public Object visitFor(For for_) throws Exception {
        int n = this.beginLoop();
        Label label = this.continueLabels.peek();
        Label label2 = this.breakLabels.peek();
        Label label3 = new Label();
        Label label4 = new Label();
        this.setline(for_);
        this.visit(for_.getInternalIter());
        int n2 = this.code.getLocal(CodegenUtils.p(PyObject.class));
        int n3 = this.code.getLocal(CodegenUtils.p(PyObject.class));
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__iter__", CodegenUtils.sig(PyObject.class, new Class[0]));
        this.code.astore(n2);
        this.code.goto_(label4);
        this.code.label(label3);
        this.set(for_.getInternalTarget(), n3);
        this.suite(for_.getInternalBody());
        this.code.label(label);
        this.code.label(label4);
        this.setline(for_);
        this.code.aload(n2);
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__iternext__", CodegenUtils.sig(PyObject.class, new Class[0]));
        this.code.astore(n3);
        this.code.aload(n3);
        this.code.ifnonnull(label3);
        this.finishLoop(n);
        if (for_.getInternalOrelse() != null) {
            this.suite(for_.getInternalOrelse());
        }
        this.code.label(label2);
        this.code.freeLocal(n2);
        this.code.freeLocal(n3);
        return null;
    }

    public void exceptionTest(int n, Label label, TryExcept tryExcept, int n2) throws Exception {
        for (int i = 0; i < tryExcept.getInternalHandlers().size(); ++i) {
            ExceptHandler exceptHandler = (ExceptHandler)tryExcept.getInternalHandlers().get(i);
            Label label2 = new Label();
            if (exceptHandler.getInternalType() != null) {
                this.code.aload(n);
                this.visit(exceptHandler.getInternalType());
                this.code.invokevirtual(CodegenUtils.p(PyException.class), "match", CodegenUtils.sig(Boolean.TYPE, PyObject.class));
                this.code.ifeq(label2);
            } else if (i != tryExcept.getInternalHandlers().size() - 1) {
                throw new ParseException("default 'except:' must be last", exceptHandler);
            }
            if (exceptHandler.getInternalName() != null) {
                this.code.aload(n);
                this.code.getfield(CodegenUtils.p(PyException.class), "value", CodegenUtils.ci(PyObject.class));
                this.set(exceptHandler.getInternalName());
            }
            this.suite(exceptHandler.getInternalBody());
            this.code.goto_(label);
            this.code.label(label2);
        }
        this.code.aload(n);
        this.code.athrow();
    }

    @Override
    public Object visitTryFinally(TryFinally tryFinally) throws Exception {
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        ExceptionHandler exceptionHandler = new ExceptionHandler(tryFinally);
        this.exceptionHandlers.push(exceptionHandler);
        int n = this.code.getLocal(CodegenUtils.p(Throwable.class));
        this.code.aconst_null();
        this.code.astore(n);
        this.code.label(label);
        exceptionHandler.exceptionStarts.addElement(label);
        Object object = this.suite(tryFinally.getInternalBody());
        this.code.label(label2);
        exceptionHandler.exceptionEnds.addElement(label2);
        exceptionHandler.bodyDone = true;
        this.exceptionHandlers.pop();
        if (object == NoExit) {
            this.inlineFinally(exceptionHandler);
            this.code.goto_(label4);
        }
        this.code.label(label3);
        this.code.astore(n);
        this.code.aload(n);
        this.loadFrame();
        this.code.invokestatic(CodegenUtils.p(Py.class), "addTraceback", CodegenUtils.sig(Void.TYPE, Throwable.class, PyFrame.class));
        this.inlineFinally(exceptionHandler);
        this.code.aload(n);
        this.code.checkcast(CodegenUtils.p(Throwable.class));
        this.code.athrow();
        this.code.label(label4);
        this.code.freeLocal(n);
        exceptionHandler.addExceptionHandlers(label3);
        return null;
    }

    private void inlineFinally(ExceptionHandler exceptionHandler) throws Exception {
        if (!exceptionHandler.bodyDone) {
            Label label = new Label();
            this.code.label(label);
            exceptionHandler.exceptionEnds.addElement(label);
        }
        if (exceptionHandler.isFinallyHandler()) {
            exceptionHandler.finalBody(this);
        }
    }

    private void reenterProtectedBody(ExceptionHandler exceptionHandler) throws Exception {
        Label label = new Label();
        this.code.label(label);
        exceptionHandler.exceptionStarts.addElement(label);
    }

    private void doFinallysDownTo(int n) throws Exception {
        ExceptionHandler exceptionHandler;
        Stack<ExceptionHandler> stack = new Stack<ExceptionHandler>();
        while (this.exceptionHandlers.size() > n) {
            exceptionHandler = this.exceptionHandlers.pop();
            this.inlineFinally(exceptionHandler);
            stack.push(exceptionHandler);
        }
        while (stack.size() > 0) {
            exceptionHandler = (ExceptionHandler)stack.pop();
            this.reenterProtectedBody(exceptionHandler);
            this.exceptionHandlers.push(exceptionHandler);
        }
    }

    @Override
    public Object visitTryExcept(TryExcept tryExcept) throws Exception {
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        this.code.label(label);
        exceptionHandler.exceptionStarts.addElement(label);
        this.exceptionHandlers.push(exceptionHandler);
        Object object = this.suite(tryExcept.getInternalBody());
        this.exceptionHandlers.pop();
        this.code.label(label2);
        exceptionHandler.exceptionEnds.addElement(label2);
        if (object == null) {
            this.code.goto_(label4);
        }
        this.code.label(label3);
        this.loadFrame();
        this.code.invokestatic(CodegenUtils.p(Py.class), "setException", CodegenUtils.sig(PyException.class, Throwable.class, PyFrame.class));
        int n = this.code.getFinallyLocal(CodegenUtils.p(Throwable.class));
        this.code.astore(n);
        if (tryExcept.getInternalOrelse() == null) {
            this.exceptionTest(n, label4, tryExcept, 1);
            this.code.label(label4);
        } else {
            Label label5 = new Label();
            this.exceptionTest(n, label5, tryExcept, 1);
            this.code.label(label4);
            this.suite(tryExcept.getInternalOrelse());
            this.code.label(label5);
        }
        this.code.freeFinallyLocal(n);
        exceptionHandler.addExceptionHandlers(label3);
        return null;
    }

    @Override
    public Object visitSuite(Suite suite) throws Exception {
        return this.suite(suite.getInternalBody());
    }

    public Object suite(java.util.List<stmt> list) throws Exception {
        for (stmt stmt2 : list) {
            Object object = this.visit(stmt2);
            if (object == null) continue;
            return Exit;
        }
        return null;
    }

    @Override
    public Object visitBoolOp(BoolOp boolOp) throws Exception {
        Label label = new Label();
        this.visit(boolOp.getInternalValues().get(0));
        for (int i = 1; i < boolOp.getInternalValues().size(); ++i) {
            this.code.dup();
            this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            switch (boolOp.getInternalOp()) {
                case Or: {
                    this.code.ifne(label);
                    break;
                }
                case And: {
                    this.code.ifeq(label);
                }
            }
            this.code.pop();
            this.visit(boolOp.getInternalValues().get(i));
        }
        this.code.label(label);
        return null;
    }

    @Override
    public Object visitCompare(Compare compare) throws Exception {
        int n = this.code.getLocal(CodegenUtils.p(PyObject.class));
        int n2 = this.code.getLocal(CodegenUtils.p(PyObject.class));
        Label label = new Label();
        this.visit(compare.getInternalLeft());
        this.code.astore(n);
        int n3 = compare.getInternalOps().size();
        for (int i = 0; i < n3 - 1; ++i) {
            this.visit(compare.getInternalComparators().get(i));
            this.code.aload(n);
            this.code.swap();
            this.code.dup();
            this.code.astore(n);
            this.visitCmpop(compare.getInternalOps().get(i));
            this.code.dup();
            this.code.astore(n2);
            this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__nonzero__", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            this.code.ifeq(label);
        }
        this.visit(compare.getInternalComparators().get(n3 - 1));
        this.code.aload(n);
        this.code.swap();
        this.visitCmpop(compare.getInternalOps().get(n3 - 1));
        if (n3 > 1) {
            this.code.astore(n2);
            this.code.label(label);
            this.code.aload(n2);
        }
        this.code.aconst_null();
        this.code.astore(n);
        this.code.freeLocal(n);
        this.code.freeLocal(n2);
        return null;
    }

    public void visitCmpop(cmpopType cmpopType2) throws Exception {
        String string = null;
        switch (cmpopType2) {
            case Eq: {
                string = "_eq";
                break;
            }
            case NotEq: {
                string = "_ne";
                break;
            }
            case Lt: {
                string = "_lt";
                break;
            }
            case LtE: {
                string = "_le";
                break;
            }
            case Gt: {
                string = "_gt";
                break;
            }
            case GtE: {
                string = "_ge";
                break;
            }
            case Is: {
                string = "_is";
                break;
            }
            case IsNot: {
                string = "_isnot";
                break;
            }
            case In: {
                string = "_in";
                break;
            }
            case NotIn: {
                string = "_notin";
            }
        }
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), string, CodegenUtils.sig(PyObject.class, PyObject.class));
    }

    @Override
    public Object visitBinOp(BinOp binOp) throws Exception {
        this.visit(binOp.getInternalLeft());
        this.stackProduce();
        this.visit(binOp.getInternalRight());
        this.stackConsume();
        String string = null;
        switch (binOp.getInternalOp()) {
            case Add: {
                string = "_add";
                break;
            }
            case Sub: {
                string = "_sub";
                break;
            }
            case Mult: {
                string = "_mul";
                break;
            }
            case Div: {
                string = "_div";
                break;
            }
            case Mod: {
                string = "_mod";
                break;
            }
            case Pow: {
                string = "_pow";
                break;
            }
            case LShift: {
                string = "_lshift";
                break;
            }
            case RShift: {
                string = "_rshift";
                break;
            }
            case BitOr: {
                string = "_or";
                break;
            }
            case BitXor: {
                string = "_xor";
                break;
            }
            case BitAnd: {
                string = "_and";
                break;
            }
            case FloorDiv: {
                string = "_floordiv";
            }
        }
        if (binOp.getInternalOp() == operatorType.Div && this.module.getFutures().areDivisionOn()) {
            string = "_truediv";
        }
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), string, CodegenUtils.sig(PyObject.class, PyObject.class));
        return null;
    }

    @Override
    public Object visitUnaryOp(UnaryOp unaryOp) throws Exception {
        this.visit(unaryOp.getInternalOperand());
        String string = null;
        switch (unaryOp.getInternalOp()) {
            case Invert: {
                string = "__invert__";
                break;
            }
            case Not: {
                string = "__not__";
                break;
            }
            case UAdd: {
                string = "__pos__";
                break;
            }
            case USub: {
                string = "__neg__";
            }
        }
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), string, CodegenUtils.sig(PyObject.class, new Class[0]));
        return null;
    }

    @Override
    public Object visitAugAssign(AugAssign augAssign) throws Exception {
        this.setline(augAssign);
        this.augmode = expr_contextType.Load;
        this.visit(augAssign.getInternalTarget());
        int n = this.storeTop();
        this.visit(augAssign.getInternalValue());
        this.code.aload(n);
        this.code.swap();
        String string = null;
        switch (augAssign.getInternalOp()) {
            case Add: {
                string = "_iadd";
                break;
            }
            case Sub: {
                string = "_isub";
                break;
            }
            case Mult: {
                string = "_imul";
                break;
            }
            case Div: {
                string = "_idiv";
                break;
            }
            case Mod: {
                string = "_imod";
                break;
            }
            case Pow: {
                string = "_ipow";
                break;
            }
            case LShift: {
                string = "_ilshift";
                break;
            }
            case RShift: {
                string = "_irshift";
                break;
            }
            case BitOr: {
                string = "_ior";
                break;
            }
            case BitXor: {
                string = "_ixor";
                break;
            }
            case BitAnd: {
                string = "_iand";
                break;
            }
            case FloorDiv: {
                string = "_ifloordiv";
            }
        }
        if (augAssign.getInternalOp() == operatorType.Div && this.module.getFutures().areDivisionOn()) {
            string = "_itruediv";
        }
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), string, CodegenUtils.sig(PyObject.class, PyObject.class));
        this.code.freeLocal(n);
        this.temporary = this.storeTop();
        this.augmode = expr_contextType.Store;
        this.visit(augAssign.getInternalTarget());
        this.code.freeLocal(this.temporary);
        return null;
    }

    static int makeStrings(Code code, Collection<String> collection) throws IOException {
        if (collection != null) {
            code.iconst(collection.size());
        } else {
            code.iconst_0();
        }
        code.anewarray(CodegenUtils.p(String.class));
        int n = code.getLocal(CodegenUtils.ci(String[].class));
        code.astore(n);
        if (collection != null) {
            int n2 = 0;
            for (String string : collection) {
                code.aload(n);
                code.iconst(n2);
                code.ldc(string);
                code.aastore();
                ++n2;
            }
        }
        return n;
    }

    public Object invokeNoKeywords(Attribute attribute, java.util.List<expr> list) throws Exception {
        String string = this.getName(attribute.getInternalAttr());
        this.visit(attribute.getInternalValue());
        this.stackProduce();
        this.code.ldc(string);
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__getattr__", CodegenUtils.sig(PyObject.class, String.class));
        this.loadThreadState();
        this.stackProduce(CodegenUtils.p(ThreadState.class));
        switch (list.size()) {
            case 0: {
                this.stackConsume(2);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class));
                break;
            }
            case 1: {
                this.visit(list.get(0));
                this.stackConsume(2);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class));
                break;
            }
            case 2: {
                this.visit(list.get(0));
                this.stackProduce();
                this.visit(list.get(1));
                this.stackConsume(3);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class, PyObject.class));
                break;
            }
            case 3: {
                this.visit(list.get(0));
                this.stackProduce();
                this.visit(list.get(1));
                this.stackProduce();
                this.visit(list.get(2));
                this.stackConsume(4);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class, PyObject.class, PyObject.class));
                break;
            }
            case 4: {
                this.visit(list.get(0));
                this.stackProduce();
                this.visit(list.get(1));
                this.stackProduce();
                this.visit(list.get(2));
                this.stackProduce();
                this.visit(list.get(3));
                this.stackConsume(5);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class, PyObject.class, PyObject.class, PyObject.class));
                break;
            }
            default: {
                int n = this.makeArray(list);
                this.code.aload(n);
                this.code.freeLocal(n);
                this.stackConsume(2);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject[].class));
            }
        }
        return null;
    }

    @Override
    public Object visitCall(Call call) throws Exception {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<expr> arrayList2 = new ArrayList<expr>();
        for (n = 0; n < call.getInternalArgs().size(); ++n) {
            arrayList2.add(call.getInternalArgs().get(n));
        }
        for (n = 0; n < call.getInternalKeywords().size(); ++n) {
            arrayList.add(call.getInternalKeywords().get(n).getInternalArg());
            arrayList2.add(call.getInternalKeywords().get(n).getInternalValue());
        }
        if ((call.getInternalKeywords() == null || call.getInternalKeywords().size() == 0) && call.getInternalStarargs() == null && call.getInternalKwargs() == null && call.getInternalFunc() instanceof Attribute) {
            return this.invokeNoKeywords((Attribute)call.getInternalFunc(), arrayList2);
        }
        this.visit(call.getInternalFunc());
        this.stackProduce();
        if (call.getInternalStarargs() != null || call.getInternalKwargs() != null) {
            n = this.makeArray(arrayList2);
            int n2 = CodeCompiler.makeStrings(this.code, arrayList);
            if (call.getInternalStarargs() == null) {
                this.code.aconst_null();
            } else {
                this.visit(call.getInternalStarargs());
            }
            this.stackProduce();
            if (call.getInternalKwargs() == null) {
                this.code.aconst_null();
            } else {
                this.visit(call.getInternalKwargs());
            }
            this.stackProduce();
            this.code.aload(n);
            this.code.aload(n2);
            this.code.freeLocal(n2);
            this.code.dup2_x2();
            this.code.pop2();
            this.stackConsume(3);
            this.code.invokevirtual(CodegenUtils.p(PyObject.class), "_callextra", CodegenUtils.sig(PyObject.class, PyObject[].class, String[].class, PyObject.class, PyObject.class));
            this.freeArrayRef(n);
        } else if (arrayList.size() > 0) {
            this.loadThreadState();
            this.stackProduce(CodegenUtils.p(ThreadState.class));
            n = this.makeArray(arrayList2);
            int n3 = CodeCompiler.makeStrings(this.code, arrayList);
            this.code.aload(n);
            this.code.aload(n3);
            this.code.freeLocal(n3);
            this.stackConsume(2);
            this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject[].class, String[].class));
            this.freeArrayRef(n);
        } else {
            this.loadThreadState();
            this.stackProduce(CodegenUtils.p(ThreadState.class));
            switch (arrayList2.size()) {
                case 0: {
                    this.stackConsume(2);
                    this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class));
                    break;
                }
                case 1: {
                    this.visit((PythonTree)arrayList2.get(0));
                    this.stackConsume(2);
                    this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class));
                    break;
                }
                case 2: {
                    this.visit((PythonTree)arrayList2.get(0));
                    this.stackProduce();
                    this.visit((PythonTree)arrayList2.get(1));
                    this.stackConsume(3);
                    this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class, PyObject.class));
                    break;
                }
                case 3: {
                    this.visit((PythonTree)arrayList2.get(0));
                    this.stackProduce();
                    this.visit((PythonTree)arrayList2.get(1));
                    this.stackProduce();
                    this.visit((PythonTree)arrayList2.get(2));
                    this.stackConsume(4);
                    this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class, PyObject.class, PyObject.class));
                    break;
                }
                case 4: {
                    this.visit((PythonTree)arrayList2.get(0));
                    this.stackProduce();
                    this.visit((PythonTree)arrayList2.get(1));
                    this.stackProduce();
                    this.visit((PythonTree)arrayList2.get(2));
                    this.stackProduce();
                    this.visit((PythonTree)arrayList2.get(3));
                    this.stackConsume(5);
                    this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class, PyObject.class, PyObject.class, PyObject.class));
                    break;
                }
                default: {
                    n = this.makeArray(arrayList2);
                    this.code.aload(n);
                    this.code.freeLocal(n);
                    this.stackConsume(2);
                    this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject[].class));
                }
            }
        }
        return null;
    }

    public Object Slice(Subscript subscript, Slice slice2) throws Exception {
        expr_contextType expr_contextType2 = subscript.getInternalCtx();
        if (expr_contextType2 == expr_contextType.AugStore && this.augmode == expr_contextType.Store) {
            this.restoreAugTmps(subscript, 4);
            expr_contextType2 = expr_contextType.Store;
        } else {
            this.visit(subscript.getInternalValue());
            this.stackProduce();
            if (slice2.getInternalLower() != null) {
                this.visit(slice2.getInternalLower());
            } else {
                this.code.aconst_null();
            }
            this.stackProduce();
            if (slice2.getInternalUpper() != null) {
                this.visit(slice2.getInternalUpper());
            } else {
                this.code.aconst_null();
            }
            this.stackProduce();
            if (slice2.getInternalStep() != null) {
                this.visit(slice2.getInternalStep());
            } else {
                this.code.aconst_null();
            }
            this.stackProduce();
            if (subscript.getInternalCtx() == expr_contextType.AugStore && this.augmode == expr_contextType.Load) {
                this.saveAugTmps(subscript, 4);
                expr_contextType2 = expr_contextType.Load;
            }
            this.stackConsume(4);
        }
        switch (expr_contextType2) {
            case Del: {
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__delslice__", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class, PyObject.class));
                return null;
            }
            case Load: {
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__getslice__", CodegenUtils.sig(PyObject.class, PyObject.class, PyObject.class, PyObject.class));
                return null;
            }
            case Param: 
            case Store: {
                this.code.aload(this.temporary);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__setslice__", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class, PyObject.class, PyObject.class));
                return null;
            }
        }
        return null;
    }

    @Override
    public Object visitSubscript(Subscript subscript) throws Exception {
        if (subscript.getInternalSlice() instanceof Slice) {
            return this.Slice(subscript, (Slice)subscript.getInternalSlice());
        }
        int n = this.temporary;
        expr_contextType expr_contextType2 = subscript.getInternalCtx();
        if (subscript.getInternalCtx() == expr_contextType.AugStore && this.augmode == expr_contextType.Store) {
            this.restoreAugTmps(subscript, 2);
            expr_contextType2 = expr_contextType.Store;
        } else {
            this.visit(subscript.getInternalValue());
            this.stackProduce();
            this.visit(subscript.getInternalSlice());
            this.stackConsume();
            if (subscript.getInternalCtx() == expr_contextType.AugStore && this.augmode == expr_contextType.Load) {
                this.saveAugTmps(subscript, 2);
                expr_contextType2 = expr_contextType.Load;
            }
        }
        switch (expr_contextType2) {
            case Del: {
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__delitem__", CodegenUtils.sig(Void.TYPE, PyObject.class));
                return null;
            }
            case Load: {
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__getitem__", CodegenUtils.sig(PyObject.class, PyObject.class));
                return null;
            }
            case Param: 
            case Store: {
                this.code.aload(n);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__setitem__", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class));
                return null;
            }
        }
        return null;
    }

    @Override
    public Object visitIndex(Index index) throws Exception {
        this.traverse(index);
        return null;
    }

    @Override
    public Object visitExtSlice(ExtSlice extSlice) throws Exception {
        int n = this.makeArray(extSlice.getInternalDims());
        this.code.new_(CodegenUtils.p(PyTuple.class));
        this.code.dup();
        this.code.aload(n);
        this.code.invokespecial(CodegenUtils.p(PyTuple.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject[].class));
        this.freeArray(n);
        return null;
    }

    @Override
    public Object visitAttribute(Attribute attribute) throws Exception {
        expr_contextType expr_contextType2 = attribute.getInternalCtx();
        if (attribute.getInternalCtx() == expr_contextType.AugStore && this.augmode == expr_contextType.Store) {
            this.restoreAugTmps(attribute, 2);
            expr_contextType2 = expr_contextType.Store;
        } else {
            this.visit(attribute.getInternalValue());
            this.code.ldc(this.getName(attribute.getInternalAttr()));
            if (attribute.getInternalCtx() == expr_contextType.AugStore && this.augmode == expr_contextType.Load) {
                this.saveAugTmps(attribute, 2);
                expr_contextType2 = expr_contextType.Load;
            }
        }
        switch (expr_contextType2) {
            case Del: {
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__delattr__", CodegenUtils.sig(Void.TYPE, String.class));
                return null;
            }
            case Load: {
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__getattr__", CodegenUtils.sig(PyObject.class, String.class));
                return null;
            }
            case Param: 
            case Store: {
                this.code.aload(this.temporary);
                this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__setattr__", CodegenUtils.sig(Void.TYPE, String.class, PyObject.class));
                return null;
            }
        }
        return null;
    }

    public Object seqSet(java.util.List<expr> list) throws Exception {
        this.code.aload(this.temporary);
        this.code.iconst(list.size());
        this.code.invokestatic(CodegenUtils.p(Py.class), "unpackSequence", CodegenUtils.sig(PyObject[].class, PyObject.class, Integer.TYPE));
        int n = this.code.getLocal("[org/python/core/PyObject");
        this.code.astore(n);
        for (int i = 0; i < list.size(); ++i) {
            this.code.aload(n);
            this.code.iconst(i);
            this.code.aaload();
            this.set(list.get(i));
        }
        this.code.freeLocal(n);
        return null;
    }

    public Object seqDel(java.util.List<expr> list) throws Exception {
        for (expr expr2 : list) {
            this.visit(expr2);
        }
        return null;
    }

    @Override
    public Object visitTuple(Tuple tuple) throws Exception {
        if (tuple.getInternalCtx() == expr_contextType.Store) {
            return this.seqSet(tuple.getInternalElts());
        }
        if (tuple.getInternalCtx() == expr_contextType.Del) {
            return this.seqDel(tuple.getInternalElts());
        }
        int n = this.makeArray(tuple.getInternalElts());
        this.code.new_(CodegenUtils.p(PyTuple.class));
        this.code.dup();
        this.code.aload(n);
        this.code.invokespecial(CodegenUtils.p(PyTuple.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject[].class));
        this.freeArray(n);
        return null;
    }

    @Override
    public Object visitList(List list) throws Exception {
        if (list.getInternalCtx() == expr_contextType.Store) {
            return this.seqSet(list.getInternalElts());
        }
        if (list.getInternalCtx() == expr_contextType.Del) {
            return this.seqDel(list.getInternalElts());
        }
        int n = this.makeArray(list.getInternalElts());
        this.code.new_(CodegenUtils.p(PyList.class));
        this.code.dup();
        this.code.aload(n);
        this.code.invokespecial(CodegenUtils.p(PyList.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject[].class));
        this.freeArray(n);
        return null;
    }

    @Override
    public Object visitListComp(ListComp listComp) throws Exception {
        this.code.new_(CodegenUtils.p(PyList.class));
        this.code.dup();
        this.code.invokespecial(CodegenUtils.p(PyList.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        this.code.dup();
        this.code.ldc("append");
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__getattr__", CodegenUtils.sig(PyObject.class, String.class));
        String string = "_[" + listComp.getLine() + "_" + listComp.getCharPositionInLine() + "]";
        this.set(new Name(listComp, string, expr_contextType.Store));
        ArrayList<expr> arrayList = new ArrayList<expr>();
        arrayList.add(listComp.getInternalElt());
        stmt stmt2 = new Expr(listComp, (expr)new Call(listComp, (expr)new Name(listComp, string, expr_contextType.Load), arrayList, new ArrayList<keyword>(), null, null));
        for (int i = listComp.getInternalGenerators().size() - 1; i >= 0; --i) {
            comprehension comprehension2 = listComp.getInternalGenerators().get(i);
            for (int j = comprehension2.getInternalIfs().size() - 1; j >= 0; --j) {
                ArrayList<stmt> arrayList2 = new ArrayList<stmt>();
                arrayList2.add(stmt2);
                stmt2 = new If(comprehension2.getInternalIfs().get(j), comprehension2.getInternalIfs().get(j), arrayList2, new ArrayList<stmt>());
            }
            ArrayList<stmt> arrayList3 = new ArrayList<stmt>();
            arrayList3.add(stmt2);
            stmt2 = new For(comprehension2, comprehension2.getInternalTarget(), comprehension2.getInternalIter(), arrayList3, new ArrayList<stmt>());
        }
        this.visit(stmt2);
        ArrayList<expr> arrayList4 = new ArrayList<expr>();
        arrayList4.add(new Name(stmt2, string, expr_contextType.Del));
        this.visit(new Delete(stmt2, arrayList4));
        return null;
    }

    @Override
    public Object visitDict(Dict dict) throws Exception {
        int n;
        ArrayList<expr> arrayList = new ArrayList<expr>();
        for (n = 0; n < dict.getInternalKeys().size(); ++n) {
            arrayList.add(dict.getInternalKeys().get(n));
            arrayList.add(dict.getInternalValues().get(n));
        }
        n = this.makeArray(arrayList);
        this.code.new_(CodegenUtils.p(PyDictionary.class));
        this.code.dup();
        this.code.aload(n);
        this.code.invokespecial(CodegenUtils.p(PyDictionary.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject[].class));
        this.freeArray(n);
        return null;
    }

    @Override
    public Object visitRepr(Repr repr) throws Exception {
        this.visit(repr.getInternalValue());
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__repr__", CodegenUtils.sig(PyString.class, new Class[0]));
        return null;
    }

    @Override
    public Object visitLambda(Lambda lambda) throws Exception {
        String string = "<lambda>";
        ArrayList<stmt> arrayList = new ArrayList<stmt>();
        arrayList.add(new Return(lambda, lambda.getInternalBody()));
        Suite suite = new Suite(lambda, arrayList);
        this.setline(lambda);
        ScopeInfo scopeInfo = this.module.getScopeInfo(lambda);
        int n = this.makeArray(scopeInfo.ac.getDefaults());
        this.code.new_(CodegenUtils.p(PyFunction.class));
        this.code.dup();
        this.code.aload(n);
        this.code.freeLocal(n);
        this.loadFrame();
        this.code.getfield(CodegenUtils.p(PyFrame.class), "f_globals", CodegenUtils.ci(PyObject.class));
        this.code.swap();
        scopeInfo.setup_closure();
        scopeInfo.dump();
        this.module.codeConstant(suite, string, true, this.className, false, false, lambda.getLine(), scopeInfo, this.cflags).get(this.code);
        if (!this.makeClosure(scopeInfo)) {
            this.code.invokespecial(CodegenUtils.p(PyFunction.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject[].class, PyCode.class));
        } else {
            this.code.invokespecial(CodegenUtils.p(PyFunction.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject[].class, PyCode.class, PyObject[].class));
        }
        return null;
    }

    @Override
    public Object visitEllipsis(Ellipsis ellipsis) throws Exception {
        this.code.getstatic(CodegenUtils.p(Py.class), "Ellipsis", CodegenUtils.ci(PyObject.class));
        return null;
    }

    @Override
    public Object visitSlice(Slice slice2) throws Exception {
        if (slice2.getInternalLower() == null) {
            this.getNone();
        } else {
            this.visit(slice2.getInternalLower());
        }
        this.stackProduce();
        if (slice2.getInternalUpper() == null) {
            this.getNone();
        } else {
            this.visit(slice2.getInternalUpper());
        }
        this.stackProduce();
        if (slice2.getInternalStep() == null) {
            this.getNone();
        } else {
            this.visit(slice2.getInternalStep());
        }
        int n = this.storeTop();
        this.stackConsume(2);
        this.code.new_(CodegenUtils.p(PySlice.class));
        this.code.dup();
        this.code.dup2_x2();
        this.code.pop2();
        this.code.aload(n);
        this.code.freeLocal(n);
        this.code.invokespecial(CodegenUtils.p(PySlice.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject.class, PyObject.class));
        return null;
    }

    @Override
    public Object visitClassDef(ClassDef classDef) throws Exception {
        this.setline(classDef);
        int n = this.makeArray(classDef.getInternalBases());
        String string = this.getName(classDef.getInternalName());
        this.code.ldc(string);
        this.code.aload(n);
        ScopeInfo scopeInfo = this.module.getScopeInfo(classDef);
        scopeInfo.setup_closure();
        scopeInfo.dump();
        this.module.codeConstant(new Suite(classDef, classDef.getInternalBody()), string, false, string, this.getDocStr(classDef.getInternalBody()), true, false, classDef.getLine(), scopeInfo, this.cflags).get(this.code);
        if (!this.makeClosure(scopeInfo)) {
            this.code.invokestatic(CodegenUtils.p(Py.class), "makeClass", CodegenUtils.sig(PyObject.class, String.class, PyObject[].class, PyCode.class));
        } else {
            this.code.invokestatic(CodegenUtils.p(Py.class), "makeClass", CodegenUtils.sig(PyObject.class, String.class, PyObject[].class, PyCode.class, PyObject[].class));
        }
        this.applyDecorators(classDef.getInternalDecorator_list());
        this.set(new Name(classDef, classDef.getInternalName(), expr_contextType.Store));
        this.freeArray(n);
        return null;
    }

    @Override
    public Object visitNum(Num num) throws Exception {
        if (num.getInternalN() instanceof PyInteger) {
            this.module.integerConstant(((PyInteger)num.getInternalN()).getValue()).get(this.code);
        } else if (num.getInternalN() instanceof PyLong) {
            this.module.longConstant(((PyObject)num.getInternalN()).__str__().toString()).get(this.code);
        } else if (num.getInternalN() instanceof PyFloat) {
            this.module.floatConstant(((PyFloat)num.getInternalN()).getValue()).get(this.code);
        } else if (num.getInternalN() instanceof PyComplex) {
            this.module.complexConstant(((PyComplex)num.getInternalN()).imag).get(this.code);
        }
        return null;
    }

    private String getName(String string) {
        if (this.className != null && string.startsWith("__") && !string.endsWith("__")) {
            int n = 0;
            while (this.className.charAt(n) == '_') {
                ++n;
            }
            return "_" + this.className.substring(n) + string;
        }
        return string;
    }

    void emitGetGlobal(String string) throws Exception {
        this.code.ldc(string);
        this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getglobal", CodegenUtils.sig(PyObject.class, String.class));
    }

    @Override
    public Object visitName(Name name) throws Exception {
        String string = this.fast_locals ? name.getInternalId() : this.getName(name.getInternalId());
        SymInfo symInfo = this.tbl.get(string);
        expr_contextType expr_contextType2 = name.getInternalCtx();
        if (expr_contextType2 == expr_contextType.AugStore) {
            expr_contextType2 = this.augmode;
        }
        switch (expr_contextType2) {
            case Load: {
                this.loadFrame();
                if (symInfo != null) {
                    int n = symInfo.flags;
                    if ((n & 0x42) != 0 || this.optimizeGlobals && (n & 0x31) == 0) {
                        this.emitGetGlobal(string);
                        return null;
                    }
                    if (this.fast_locals) {
                        if ((n & 0x10) != 0) {
                            this.code.iconst(symInfo.env_index);
                            this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getderef", CodegenUtils.sig(PyObject.class, Integer.TYPE));
                            return null;
                        }
                        if ((n & 1) != 0) {
                            this.code.iconst(symInfo.locals_index);
                            this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getlocal", CodegenUtils.sig(PyObject.class, Integer.TYPE));
                            return null;
                        }
                    }
                    if ((n & 0x20) != 0 && (n & 1) == 0) {
                        this.code.iconst(symInfo.env_index);
                        this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getderef", CodegenUtils.sig(PyObject.class, Integer.TYPE));
                        return null;
                    }
                }
                this.code.ldc(string);
                this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "getname", CodegenUtils.sig(PyObject.class, String.class));
                return null;
            }
            case Param: 
            case Store: {
                this.loadFrame();
                if (symInfo != null && (symInfo.flags & 0x42) != 0) {
                    this.code.ldc(string);
                    this.code.aload(this.temporary);
                    this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "setglobal", CodegenUtils.sig(Void.TYPE, String.class, PyObject.class));
                } else if (!this.fast_locals) {
                    this.code.ldc(string);
                    this.code.aload(this.temporary);
                    this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "setlocal", CodegenUtils.sig(Void.TYPE, String.class, PyObject.class));
                } else {
                    if (symInfo == null) {
                        throw new ParseException("internal compiler error", name);
                    }
                    if ((symInfo.flags & 0x10) != 0) {
                        this.code.iconst(symInfo.env_index);
                        this.code.aload(this.temporary);
                        this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "setderef", CodegenUtils.sig(Void.TYPE, Integer.TYPE, PyObject.class));
                    } else {
                        this.code.iconst(symInfo.locals_index);
                        this.code.aload(this.temporary);
                        this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "setlocal", CodegenUtils.sig(Void.TYPE, Integer.TYPE, PyObject.class));
                    }
                }
                return null;
            }
            case Del: {
                this.loadFrame();
                if (symInfo != null && (symInfo.flags & 0x42) != 0) {
                    this.code.ldc(string);
                    this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "delglobal", CodegenUtils.sig(Void.TYPE, String.class));
                } else if (!this.fast_locals) {
                    this.code.ldc(string);
                    this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "dellocal", CodegenUtils.sig(Void.TYPE, String.class));
                } else {
                    if (symInfo == null) {
                        throw new ParseException("internal compiler error", name);
                    }
                    if ((symInfo.flags & 0x10) != 0) {
                        this.module.error("can not delete variable '" + string + "' referenced in nested scope", true, name);
                    }
                    this.code.iconst(symInfo.locals_index);
                    this.code.invokevirtual(CodegenUtils.p(PyFrame.class), "dellocal", CodegenUtils.sig(Void.TYPE, Integer.TYPE));
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Object visitStr(Str str) throws Exception {
        PyString pyString = (PyString)str.getInternalS();
        if (pyString instanceof PyUnicode) {
            this.module.unicodeConstant(pyString.asString()).get(this.code);
        } else {
            this.module.stringConstant(pyString.asString()).get(this.code);
        }
        return null;
    }

    @Override
    public Object visitGeneratorExp(GeneratorExp generatorExp) throws Exception {
        String string = "_(x)";
        this.setline(generatorExp);
        this.code.new_(CodegenUtils.p(PyFunction.class));
        this.code.dup();
        this.loadFrame();
        this.code.getfield(CodegenUtils.p(PyFrame.class), "f_globals", CodegenUtils.ci(PyObject.class));
        ScopeInfo scopeInfo = this.module.getScopeInfo(generatorExp);
        int n = this.makeArray(new ArrayList());
        this.code.aload(n);
        scopeInfo.setup_closure();
        scopeInfo.dump();
        stmt stmt2 = new Expr(generatorExp, (expr)new Yield(generatorExp, generatorExp.getInternalElt()));
        expr expr2 = null;
        for (int i = generatorExp.getInternalGenerators().size() - 1; i >= 0; --i) {
            comprehension comprehension2 = generatorExp.getInternalGenerators().get(i);
            for (int j = comprehension2.getInternalIfs().size() - 1; j >= 0; --j) {
                ArrayList<stmt> arrayList = new ArrayList<stmt>();
                arrayList.add(stmt2);
                stmt2 = new If(comprehension2.getInternalIfs().get(j), comprehension2.getInternalIfs().get(j), arrayList, new ArrayList<stmt>());
            }
            ArrayList<stmt> arrayList = new ArrayList<stmt>();
            arrayList.add(stmt2);
            if (i != 0) {
                stmt2 = new For(comprehension2, comprehension2.getInternalTarget(), comprehension2.getInternalIter(), arrayList, new ArrayList<stmt>());
                continue;
            }
            stmt2 = new For(comprehension2, comprehension2.getInternalTarget(), (expr)new Name(generatorExp, string, expr_contextType.Load), arrayList, new ArrayList<stmt>());
            expr2 = comprehension2.getInternalIter();
        }
        ArrayList<stmt> arrayList = new ArrayList<stmt>();
        arrayList.add(stmt2);
        this.module.codeConstant(new Suite(generatorExp, arrayList), "<genexpr>", true, this.className, false, false, generatorExp.getLine(), scopeInfo, this.cflags).get(this.code);
        this.code.aconst_null();
        if (!this.makeClosure(scopeInfo)) {
            this.code.invokespecial(CodegenUtils.p(PyFunction.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject[].class, PyCode.class, PyObject.class));
        } else {
            this.code.invokespecial(CodegenUtils.p(PyFunction.class), "<init>", CodegenUtils.sig(Void.TYPE, PyObject.class, PyObject[].class, PyCode.class, PyObject.class, PyObject[].class));
        }
        int n2 = this.storeTop();
        this.visit(expr2);
        this.code.aload(n2);
        this.code.freeLocal(n2);
        this.code.swap();
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__iter__", CodegenUtils.sig(PyObject.class, new Class[0]));
        this.loadThreadState();
        this.code.swap();
        this.code.invokevirtual(CodegenUtils.p(PyObject.class), "__call__", CodegenUtils.sig(PyObject.class, ThreadState.class, PyObject.class));
        this.freeArray(n);
        return null;
    }

    @Override
    public Object visitWith(With with) throws Exception {
        if (!this.module.getFutures().withStatementSupported()) {
            throw new ParseException("'with' will become a reserved keyword in Python 2.6", with);
        }
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        Method method = Method.getMethod("org.python.core.ContextManager getManager (org.python.core.PyObject)");
        Method method2 = Method.getMethod("org.python.core.PyObject __enter__ (org.python.core.ThreadState)");
        final Method method3 = Method.getMethod("boolean __exit__ (org.python.core.ThreadState,org.python.core.PyException)");
        this.visit(with.getInternalContext_expr());
        this.code.invokestatic(Type.getType(ContextGuard.class).getInternalName(), method.getName(), method.getDescriptor());
        this.code.dup();
        final int n = this.code.getLocal(Type.getType(ContextManager.class).getInternalName());
        this.code.astore(n);
        this.loadThreadState();
        this.code.invokeinterface(Type.getType(ContextManager.class).getInternalName(), method2.getName(), method2.getDescriptor());
        int n2 = this.code.getLocal(CodegenUtils.p(PyObject.class));
        this.code.astore(n2);
        ExceptionHandler exceptionHandler = new ExceptionHandler(){

            public boolean isFinallyHandler() {
                return true;
            }

            public void finalBody(CodeCompiler codeCompiler) throws Exception {
                codeCompiler.code.aload(n);
                CodeCompiler.this.loadThreadState();
                codeCompiler.code.aconst_null();
                codeCompiler.code.invokeinterface(Type.getType(ContextManager.class).getInternalName(), method3.getName(), method3.getDescriptor());
                codeCompiler.code.pop();
            }
        };
        this.exceptionHandlers.push(exceptionHandler);
        ExceptionHandler exceptionHandler2 = new ExceptionHandler();
        this.exceptionHandlers.push(exceptionHandler2);
        exceptionHandler2.exceptionStarts.addElement(label);
        this.code.label(label);
        if (with.getInternalOptional_vars() != null) {
            this.set(with.getInternalOptional_vars(), n2);
        }
        this.code.freeLocal(n2);
        Object object = this.suite(with.getInternalBody());
        exceptionHandler.bodyDone = true;
        this.exceptionHandlers.pop();
        this.exceptionHandlers.pop();
        this.code.label(label2);
        exceptionHandler2.exceptionEnds.addElement(label2);
        if (object == NoExit) {
            this.inlineFinally(exceptionHandler);
            this.code.goto_(label4);
        }
        this.code.label(label3);
        this.loadFrame();
        this.code.invokestatic(CodegenUtils.p(Py.class), "setException", CodegenUtils.sig(PyException.class, Throwable.class, PyFrame.class));
        this.code.aload(n);
        this.code.swap();
        this.loadThreadState();
        this.code.swap();
        this.code.invokeinterface(Type.getType(ContextManager.class).getInternalName(), method3.getName(), method3.getDescriptor());
        this.code.ifne(label4);
        this.code.invokestatic(CodegenUtils.p(Py.class), "makeException", CodegenUtils.sig(PyException.class, new Class[0]));
        this.code.checkcast(CodegenUtils.p(Throwable.class));
        this.code.athrow();
        this.code.label(label4);
        this.code.freeLocal(n);
        exceptionHandler2.addExceptionHandlers(label3);
        return null;
    }

    @Override
    protected Object unhandled_node(PythonTree pythonTree) throws Exception {
        throw new Exception("Unhandled node " + pythonTree);
    }

    class ExceptionHandler {
        public Vector<Label> exceptionStarts = new Vector();
        public Vector<Label> exceptionEnds = new Vector();
        public boolean bodyDone = false;
        public PythonTree node = null;

        public ExceptionHandler() {
        }

        public ExceptionHandler(PythonTree pythonTree) {
            this.node = pythonTree;
        }

        public boolean isFinallyHandler() {
            return this.node != null;
        }

        public void addExceptionHandlers(Label label) throws Exception {
            for (int i = 0; i < this.exceptionStarts.size(); ++i) {
                Label label2 = this.exceptionStarts.elementAt(i);
                Label label3 = this.exceptionEnds.elementAt(i);
                if (label2.getOffset() == label3.getOffset()) continue;
                CodeCompiler.this.code.trycatch(this.exceptionStarts.elementAt(i), this.exceptionEnds.elementAt(i), label, CodegenUtils.p(Throwable.class));
            }
        }

        public void finalBody(CodeCompiler codeCompiler) throws Exception {
            if (this.node instanceof TryFinally) {
                CodeCompiler.this.suite(((TryFinally)this.node).getInternalFinalbody());
            }
        }
    }
}

